Imports System.Windows.Forms
Imports System.Drawing

Public Class AdvancedShape

  Implements PluggableShape

  Public Function GetMenuItem(ByVal Click As EventHandler) _
    As MenuItem Implements PluggableShape.GetMenuItem

    Dim MenuItem As New MenuItem("Pentagon")
    AddHandler MenuItem.Click, Click

    Return MenuItem
  End Function

  Public Function GetPoints(ByVal Rect As Rectangle) As Point()
    Dim p1 As New Point(Rect.X + Rect.Width / 2, Rect.Y)
    Dim p2 As New Point(Rect.X, Rect.Y + Rect.Height / 3)
    Dim p3 As New Point(Rect.X + Rect.Width / 4, _
      Rect.Y + Rect.Height)
    Dim p4 As New Point(Rect.X + Rect.Width * 3 / 4, _
      Rect.Y + Rect.Height)
    Dim p5 As New Point(Rect.X + Rect.Width, _
      Rect.Y + Rect.Height / 3)

    Return New Point() {p1, p2, p3, p4, p5}
  End Function

  Public Sub Draw(ByVal Graphics As Graphics, _
    ByVal Rect As Rectangle) _
    Implements PluggableShape.Draw

    Graphics.DrawPolygon(Pens.Red, GetPoints(Rect))
  End Sub

End Class

Public Interface PluggableShape

  Function GetMenuItem(ByVal Click As EventHandler) As MenuItem
  Sub Draw(ByVal Graphics As Graphics, _
    ByVal Rect As Rectangle)

End Interface